<?php
/**
 * Plugin Name: my-new-awesome-plugin
 * Plugin URI: https://xrpublisher.com
 * Description: this is an awesome plugin! Install it!
 * Version: 3.3
 * Requires at least: 5.7
 * Requires PHP: 7.1.0
 * Author: antpb
 * Author URI: http://antpb.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: my-new-awesome-plugin
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'class-example-upgrader.php';

define('MY_NEW_AWESOME_PLUGIN_VERSION', '3.3');
define('MY_NEW_AWESOME_PLUGIN_JSON', 'https://pub-2ef6bc2ae372488daf94a858e2b752ac.r2.dev/plugins/my-new-awesome-plugin/my-new-awesome-plugin.json');
define('MY_NEW_AWESOME_PLUGIN_WORKER_ENDPOINT', 'https://micro-plugin-publisher.sxpdigital.workers.dev');

register_activation_hook(__FILE__, 'handle_plugin_activation');

function handle_plugin_activation() {
    add_option('my_new_awesome_plugin_pending_activation', true);
}

function handle_pending_activation() {
    if (get_option('my_new_awesome_plugin_pending_activation')) {
        delete_option('my_new_awesome_plugin_pending_activation');
        
        if (!get_option('my_new_awesome_plugin_activation_tracked')) {
            $activation_url = MY_NEW_AWESOME_PLUGIN_WORKER_ENDPOINT . '/activate';
            $activation_url = add_query_arg(array(
                'author' => 'antpb',
                'slug' => 'my-new-awesome-plugin'
            ), $activation_url);

            $response = wp_remote_get($activation_url, array(
                'timeout' => 30,
                'sslverify' => true
            ));

            if (!is_wp_error($response)) {
                $response_code = wp_remote_retrieve_response_code($response);
                if ($response_code === 200) {
                    update_option('my_new_awesome_plugin_activation_tracked', true);
                    error_log('My New Awesome Plugin: Activation tracked successfully');
                } else {
                    error_log('My New Awesome Plugin: Activation failed with response code ' . $response_code);
                }
            } else {
                error_log('My New Awesome Plugin: Activation error - ' . $response->get_error_message());
            }
        }
    }
}
add_action('admin_init', 'handle_pending_activation');

function initialize_Micro_Plugin_Publisher_Updater() {
    $plugin_slug = 'my-new-awesome-plugin';
    $plugin_name = plugin_basename(__FILE__);
    $version = MY_NEW_AWESOME_PLUGIN_VERSION;
    $metadata_url = MY_NEW_AWESOME_PLUGIN_JSON;
    $zip_url = 'https://pub-2ef6bc2ae372488daf94a858e2b752ac.r2.dev/plugins/my-new-awesome-plugin/my-new-awesome-plugin.zip';
    new microUpgrader\Micro_Plugin_Publisher_Updater($plugin_slug, $plugin_name, $version, $metadata_url, $zip_url);
}
add_action('init', 'initialize_Micro_Plugin_Publisher_Updater');