import { __ } from "@wordpress/i18n";
import React, { useState, useEffect } from "react";
import { DropZone } from "@wordpress/components";
import { dispatch } from '@wordpress/data';
import "./editor.scss";
import {
	useBlockProps,
	ColorPalette,
	InspectorControls,
	MediaUpload
} from "@wordpress/block-editor";
import {
	Panel,
	PanelBody,
	PanelRow,
	RangeControl,
	ToggleControl,
	SelectControl,
	TextControl,
	TextareaControl
} from "@wordpress/components";
import { more } from "@wordpress/icons";

export default function Edit({ attributes, setAttributes, isSelected, clientId }) {

	const { select, dispatch } = wp.data;

	const { onSelectionChange, getSelectedBlock } = wp.blocks;
	useEffect(() => {
		if( isSelected ){
			dispatch( 'three-object-environment-events' ).setFocusEvent( clientId );
		}
	}, [isSelected]);

	const onChangePositionX = (positionX) => {
		setAttributes({ positionX });
	};
	const onChangePositionY = (positionY) => {
		setAttributes({ positionY });
	};
	const onChangePositionZ = (positionZ) => {
		setAttributes({ positionZ });
	};

	const onChangeRotationX = (rotationX) => {
		setAttributes({ rotationX });
	};
	const onChangeRotationY = (rotationY) => {
		setAttributes({ rotationY });
	};
	const onChangeRotationZ = (rotationZ) => {
		setAttributes({ rotationZ });
	};

	const onChangeName = (name) => {
		setAttributes({ name });
	};
	const onChangePersonality = (personality) => {
		setAttributes({ personality });
	};

	const onChangeDefaultMessage = (defaultMessage) => {
		setAttributes({ defaultMessage });
	};

	const onImageSelect = (imageObject) => {
		setAttributes({ threeObjectUrl: null });
		setAttributes({ threeObjectUrl: imageObject.url });
	};

	const onChangeObjectAwareness = (objectAwarenessSetting) => {
		setAttributes({ objectAwareness: objectAwarenessSetting });
	};

	const [enteredURL, setEnteredURL] = useState("");

	const { mediaUpload } = wp.editor;

	const ALLOWED_MEDIA_TYPES = [
		"model/gltf-binary",
		"application/octet-stream"
	];

	const MyDropZone = () => {
		const [hasDropped, setHasDropped] = useState(false);
		return (
			<div>
				{hasDropped ? "Dropped!" : "Drop a glb here or"}
				<DropZone
					onFilesDrop={(files) =>
						mediaUpload({
							allowedTypes: ALLOWED_MEDIA_TYPES,
							filesList: files,
							onFileChange: ([images]) => {
								onImageSelect(images);
							}
						})
					}
				/>
			</div>
		);
	};

	function handleClick(objectURL) {
		if (objectURL) {
			onImageSelect(objectURL);
		}
		console.log("fail", objectURL);
	}
	return (
		<div {...useBlockProps()}>
			<InspectorControls key="setting">
				<Panel header={ __( "Settings", 'xr-publisher') }>
					<PanelBody
						title={ __( "NPC Options", 'xr-publisher') }
						icon={more}
						initialOpen={true}
					>
						<PanelRow>
							<TextControl
								label={ __( "Name", 'xr-publisher') }
								help={__( "Give your avatar a name.", 'xr-publisher')}
								value={attributes.name}
								onChange={(value) => onChangeName(value)}
							/>
						</PanelRow>
						<PanelRow>
							<TextareaControl
								label={__( "Personality", 'xr-publisher')}
								help={__( "Give your avatar a personality in 600 characters.", 'xr-publisher')}
								value={attributes.personality}
								onChange={(value) => onChangePersonality(value)}
								maxLength={600}
							/>
						</PanelRow>
						<PanelRow>
							<TextareaControl
								label={__( "Default Message", 'xr-publisher')}
								help={ __( "Give your avatar a default message to initialize with.", 'xr-publisher')}
								value={attributes.defaultMessage}
								onChange={(value) => onChangeDefaultMessage(value)}
								maxLength={600}
							/>
						</PanelRow>
						<PanelRow>
							<span>
								{ __( 'Select a VRM file to be used as your NPC in world:', 'xr-publisher' ) }
							</span>
						</PanelRow>
						<PanelRow>
							<MediaUpload
								onSelect={(imageObject) =>
									onImageSelect(imageObject)
								}
								type="image"
								label="GLB File"
								allowedTypes={ALLOWED_MEDIA_TYPES}
								value={attributes.threeObjectUrl}
								render={({ open }) => (
									<button onClick={open}>
										{attributes.threeObjectUrl
											? "Replace NPC"
											: "Select NPC"}
									</button>
								)}
							/>
						</PanelRow>
					</PanelBody>
					<PanelBody
						title={__( "Advanced Settings", 'xr-publisher')}
						icon={more}
						initialOpen={true}
					>
						<PanelRow>
							<ToggleControl
								label={ __( "Include World Objects in Prompt", 'xr-publisher') }
								help={ __( "If enabled, will result in higher token costs with your AI service provider. Use with caution.", 'xr-publisher')}
								checked={attributes.objectAwareness}
								onChange={(e) => {
									onChangeObjectAwareness(e);
								}}
							/>
						</PanelRow>
						<PanelRow>
							<legend className="blocks-base-control__label">
								{__("Position", "xr-publisher")}
							</legend>
						</PanelRow>
						<PanelRow>
							<TextControl
								className="position-inputs"
								label="X"
								// help="position x"
								value={attributes.positionX}
								onChange={(value) => onChangePositionX(value)}
							/>
							<TextControl
								className="position-inputs"
								label="Y"
								// help="position y"
								value={attributes.positionY}
								onChange={(value) => onChangePositionY(value)}
							/>
							<TextControl
								className="position-inputs"
								label="Z"
								// help="position z"
								value={attributes.positionZ}
								onChange={(value) => onChangePositionZ(value)}
							/>
						</PanelRow>
						<PanelRow>
							<legend className="blocks-base-control__label">
								{__("Rotation", "xr-publisher")}
							</legend>
						</PanelRow>
						<PanelRow>
							<TextControl
								className="position-inputs"
								label="X"
								// help="position x"
								value={attributes.rotationX}
								onChange={(value) => onChangeRotationX(value)}
							/>
							<TextControl
								className="position-inputs"
								label="Y"
								// help="position y"
								value={attributes.rotationY}
								onChange={(value) => onChangeRotationY(value)}
							/>
							<TextControl
								className="position-inputs"
								label="Z"
								// help="position z"
								value={attributes.rotationZ}
								onChange={(value) => onChangeRotationZ(value)}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			{isSelected ? (
				<>
					{attributes.threeObjectUrl ? (
						//Not selected
							<div className="xr-publisher-inner">
								<div className="xr-publisher-inner-edit-container">
									<svg
										className="custom-icon custom-icon-cube"
										viewBox="0 0 40 40"
										version="1.1"
										xmlns="http://www.w3.org/2000/svg"
									>
										<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
											<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
										</g>
									</svg>
									<p>
										<b>{ __( 'NPC block', 'xr-publisher' ) }</b>
									</p>
								</div>
								{/* <p className="xr-publisher-model-name">
									{attributes.name}
								</p> */}
							</div>
					) : (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<MediaUpload
									onSelect={(imageObject) =>
										onImageSelect(imageObject)
									}
									type="image"
									allowedTypes={ALLOWED_MEDIA_TYPES}
									value={attributes.threeObjectUrl}
									render={({ open }) => (
										<button
											className="xr-publisher-button"
											onClick={open}
										>
											{attributes.threeObjectUrl
												? __( "Replace NPC", "xr-publisher" )
												: __( "Select NPC", 'xr-publisher' ) }
										</button>
									)}
								/>
							</div>
						</div>
					)}
				</>
			) : (
				<>
					{attributes.threeObjectUrl ? (
							<div className="xr-publisher-inner">
								<div className="xr-publisher-inner-edit-container">
									<svg
										className="custom-icon custom-icon-cube"
										viewBox="0 0 40 40"
										version="1.1"
										xmlns="http://www.w3.org/2000/svg"
									>
										<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
											<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
										</g>
									</svg>
									<p>
										<b>{ __( 'NPC block', 'xr-publisher' ) }</b>
									</p>
								</div>
								{/* <p className="xr-publisher-model-name">
									{attributes.name}
								</p> */}
							</div>
					) : (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<MediaUpload
									onSelect={(imageObject) =>
										onImageSelect(imageObject)
									}
									type="image"
									allowedTypes={ALLOWED_MEDIA_TYPES}
									value={attributes.threeObjectUrl}
									render={({ open }) => (
										<button
											className="xr-publisher-button"
											onClick={open}
										>
											{attributes.threeObjectUrl
												? __( "Replace NPC", "xr-publisher" )
												: __( "Select NPC", 'xr-publisher' )}
										</button>
									)}
								/>
							</div>
						</div>
					)}
				</>
			)}
		</div>
	);
}
