import { __ } from "@wordpress/i18n";
import React, { useState, useEffect } from "react";
import "./editor.scss";
import {
	useBlockProps,
	ColorPalette,
	InspectorControls,
	MediaUpload
} from "@wordpress/block-editor";
import {
	Panel,
	PanelBody,
	PanelRow,
	RangeControl,
	ToggleControl,
	SelectControl,
	TextControl,
	DropZone,
} from "@wordpress/components";
import { more } from "@wordpress/icons";

export default function Edit({ attributes, setAttributes, isSelected, clientId }) {
	const { select, dispatch } = wp.data;
	const { onSelectionChange, getSelectedBlock } = wp.blocks;
	useEffect(() => {
		if( isSelected ){
					dispatch( 'three-object-environment-events' ).setFocusEvent( clientId );
			}
	}, [isSelected]);

	const onImageSelect = (imageObject) => {
		setAttributes({ videoUrl: null });
		setAttributes({
			videoUrl: imageObject.url,
			aspectHeight: imageObject.height,
			aspectWidth: imageObject.width
		});
	};

	const onChangeParticipantLimit = (participantLimit) => {
		setAttributes({ participantLimit });
	};
	const onChangeMultiplayerAccess = (multiplayerAccess) => {
		setAttributes({ multiplayerAccess: multiplayerAccess });
	};
	const setCustomAvatars = (customAvatars) => {
		setAttributes({ customAvatars: customAvatars });
	};

	const { mediaUpload } = wp.editor;

	const ALLOWED_MEDIA_TYPES = ["video"];
	const THREE_ALLOWED_MEDIA_TYPES = [
		"model/gltf-binary",
		"application/octet-stream"
	];

	return (
		<div {...useBlockProps()}>
			<InspectorControls key="setting">
				<Panel header={ __( "Settings", 'xr-publisher') }>
					<PanelBody
						title="Network Settings"
						icon={more}
						initialOpen={true}
					>
						{/* <PanelRow>
							<ToggleControl
								label="AutoPlay"
								help={
									attributes.autoPlay
										? __( "Item will autoplay.", 'xr-publisher' )
										: __( "Item will not autoplay.", 'xr-publisher' )
								}
								checked={attributes.autoPlay}
								onChange={(e) => {
									onChangeAutoPlay(e);
								}}
							/>
						</PanelRow> */}
						<PanelRow>
							<legend className="blocks-base-control__label">
								{__("Participant Limit", "xr-publisher")}
							</legend>
						</PanelRow>
						<PanelRow>
							<TextControl
								className="participant-limit"
								label="Participant Limit"
								value={attributes.participantLimit}
								onChange={(value) => onChangeParticipantLimit(value)}
							/>
						</PanelRow>
						<PanelRow>
						<span>{ __( "Custom Avatars:", "xr-publisher" ) }</span>
						</PanelRow>
						<PanelRow>
							<ToggleControl
									label={ __( "This setting controls if a visitor can have a custom avatar. Note that large avatars networked can impact the performance for everyone. Enable with caution.", 'xr-publisher' ) }
									help={
										attributes.customAvatars
											? __( "Custom avatars allowed.", 'xr-publisher' )
											: __( "Custom avatars disabled.", 'xr-publisher' )
									}
									checked={attributes.customAvatars ? true : false}
									onChange={(e) => {
										setCustomAvatars(e);
									}}
							/>
						</PanelRow>
					</PanelBody>
				</Panel>
			</InspectorControls>
			{isSelected ? (
				<>
					{attributes.videoUrl ? (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<p>
									<b>{__( 'Networking Block', 'xr-publisher' ) }</b>
								</p>
							</div>
						</div>
					) : (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<p>
									<b>{__( 'Networking Block', 'xr-publisher' ) }</b>
								</p>
							</div>
						</div>
					)}
				</>
			) : (
				<>
					{attributes.videoUrl ? (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<p>
									<b>{ __( 'Networking Block', 'xr-publisher' ) }</b>
								</p>
								{/* <p>URL: {attributes.threeObjectUrl}</p> */}
							</div>
						</div>
					) : (
						<div className="xr-publisher-inner">
							<div className="xr-publisher-inner-edit-container">
								<svg
									className="custom-icon custom-icon-cube"
									viewBox="0 0 40 40"
									version="1.1"
									xmlns="http://www.w3.org/2000/svg"
								>
									<g transform="matrix(1,0,0,1,-1.1686,0.622128)">
										<path d="M37.485,28.953L21.699,38.067L21.699,19.797L37.485,10.683L37.485,28.953ZM21.218,19.821L21.218,38.065L5.435,28.953L5.435,10.709L21.218,19.821ZM37.207,10.288L21.438,19.392L5.691,10.301L21.46,1.197L37.207,10.288Z" />
									</g>
								</svg>
								<p>
									<b>{__( 'Networking Block', 'xr-publisher' ) }</b>
								</p>
							</div>
						</div>
					)}
				</>
			)}
		</div>
	);
}
