<?php
/**
* Plugin Name:       XR Publisher
* Plugin URI:        https://xrpublisher.com/
* Description:       A WordPress plugin for publishing XR content with support for WebXR and popular glTF Extensions.
* Version:           2.0-alpha-2
* Requires at least: 5.7
* Requires PHP:      7.1.0
* Author:            antpb
* Author URI:        https://antpb.com
* License:           GPL v2 or later
* License URI:       https://www.gnu.org/licenses/gpl-2.0.html
* Text Domain:       xr-publisher
* Domain Path:       /languages
*/
namespace xrPublisher;
require_once 'php/Plugin.php';
use xrPublisher\Core\Plugin;
$main = new Plugin();
$main->init();
register_activation_hook( __FILE__, array( __NAMESPACE__ . '\MainOptions', 'my_plugin_activate' ) );

define('XR_PUBLISHER_PLUGIN_VERSION', '2.0-alpha-1');

class MainOptions
{
	public static function my_plugin_activate() {
		if( ! get_option( 'xr_publisher_ai_enabled' ) ) {
			update_option( 'xr_publisher_ai_enabled', true );
		}
		if( ! get_option( 'xr_publisher_mp_networkWorker' ) ) {
			update_option( 'xr_publisher_mp_networkWorker', 'https://alchemy.sxp.digital' );
		}
		// if xr_publisher_ai_openApiKey is not set, set it to empty string
		if( ! get_option( 'xr_publisher_ai_openApiKey' ) ) {
			update_option( 'xr_publisher_ai_openApiKey', '' );
		}
		if( ! get_option( 'xr_publisher_ai_allow' ) ) {
			update_option( 'xr_publisher_ai_allow', 'loggedIn' );
		}
		// Check and update 'xr_publisher_defaultAvatar' option
		if( ! get_option( 'xr_publisher_defaultAvatar' ) ) {
			update_option( 'xr_publisher_defaultAvatar', '' );
		}
		update_option('xr_publisher_plugin_version', XR_PUBLISHER_PLUGIN_VERSION);
	}
	public static function check_plugin_update() {
		// Get the last known version from options
		$last_known_version = get_option('xr_publisher_plugin_version');

		// If there's no recorded version or the current version is higher than the last known version, the plugin has been updated
		if (!$last_known_version || version_compare(XR_PUBLISHER_PLUGIN_VERSION, $last_known_version, '>')) {
			self::on_plugin_update();
		}
	}

	public static function on_plugin_update() {
		if( ! get_option( 'xr_publisher_ai_enabled' ) ) {
			update_option( 'xr_publisher_ai_enabled', true );
		}

		if( ! get_option( 'xr_publisher_mp_networkWorker' ) ) {
			update_option( 'xr_publisher_mp_networkWorker', 'https://alchemy.sxp.digital' );
		}

		// if xr_publisher_ai_openApiKey is not set, set it to empty string
		if( ! get_option( 'xr_publisher_ai_openApiKey' ) ) {
			update_option( 'xr_publisher_ai_openApiKey', '' );
		}

		if( ! get_option( 'xr_publisher_ai_allow' ) ) {
			update_option( 'xr_publisher_ai_allow', 'loggedIn' );
		}

		if( ! get_option( 'xr_publisher_defaultAvatar' ) ) {
			update_option( 'xr_publisher_defaultAvatar', '' );
		}

		if( ! get_option( 'xr_publisher_defaultVRM' ) ) {
			update_option( 'xr_publisher_defaultVRM', '' );
		}

		// Update the version in options
		update_option('xr_publisher_plugin_version', XR_PUBLISHER_PLUGIN_VERSION);
	}

	/**
	 * Check if pro version is installed
	 */
	public static function xr_publisher_is_pro() {
		if ( file_exists( __DIR__ .'/pro' )) {
			return true;
		} else {
			return false;
		}
	}

}

MainOptions::check_plugin_update();


// Include three-object-block
include_once dirname( __FILE__ ) . '/blocks/three-object-block/init.php';

// Include environment
include_once dirname( __FILE__ ) . '/blocks/environment/init.php';

// Include model
include_once dirname( __FILE__ ) . '/blocks/model-block/init.php';

// Include npc
include_once dirname( __FILE__ ) . '/blocks/npc-block/init.php';

// Include sky
include_once dirname( __FILE__ ) . '/blocks/sky-block/init.php';

// Include image
include_once dirname( __FILE__ ) . '/blocks/three-image-block/init.php';

// Include video
include_once dirname( __FILE__ ) . '/blocks/three-video-block/init.php';

// Include Networking
include_once dirname( __FILE__ ) . '/blocks/three-networking-block/init.php';

// Include audio
include_once dirname( __FILE__ ) . '/blocks/three-audio-block/init.php';

// Include light
include_once dirname( __FILE__ ) . '/blocks/three-light-block/init.php';

// Include portal
include_once dirname( __FILE__ ) . '/blocks/three-portal-block/init.php';

// Include html
include_once dirname( __FILE__ ) . '/blocks/three-text-block/init.php';

// Include spawn point
include_once dirname( __FILE__ ) . '/blocks/spawn-point-block/init.php';

if ( MainOptions::xr_publisher_is_pro() ) {
	// Include mirror block
	include_once dirname( __FILE__ ) . '/pro/blocks/three-mirror-block/init.php';
	include_once dirname( __FILE__ ) . '/pro/admin/xr-publisher-pro-settings/init.php';
}


/**
* Include the autoloader
*/
add_action( 'plugins_loaded', function () {
    if ( file_exists(__DIR__ . '/vendor/autoload.php' ) ) {
        include __DIR__ . '/vendor/autoload.php';
    }
}, 1 );

include_once dirname( __FILE__ ). '/inc/functions.php';
include_once dirname( __FILE__ ). '/inc/hooks.php';
include_once dirname( __FILE__ ) . '/admin/xr-publisher-settings/init.php';
include_once dirname( __FILE__ ) . '/php/Plugin.php';
include_once dirname( __FILE__ ) . '/inc/class-xr-publisher-updater.php';

function initialize_xr_publisher_updater() {
    $plugin_slug = 'xr-publisher';
    $plugin_name = plugin_basename(__FILE__);
    $version = XR_PUBLISHER_PLUGIN_VERSION;
    $update_url = 'https://3ov-update-service.sxpdigital.workers.dev/plugins/update/1.2/?plugin=' . $plugin_slug; // Replace with your actual update server URL

    new XR_Publisher_Updater($plugin_slug, $plugin_name, $version, $update_url);
}
add_action('init', 'xrPublisher\initialize_xr_publisher_updater');
