<?php
//Register assets for XR Publisher Settings
add_action('admin_enqueue_scripts', function () {
    
    wp_enqueue_media();
    $handle = 'xr-publisher-settings';
    if( file_exists(dirname(__FILE__, 3). "/build/admin-page-$handle.asset.php" ) ){
        $assets = include dirname(__FILE__, 3). "/build/admin-page-$handle.asset.php";
        $dependencies = $assets['dependencies'];

		wp_register_script(
			$handle,
			plugins_url("/build/admin-page-$handle.js", dirname(__FILE__, 2)),
			$dependencies,
			$assets['version'],
			true
		);
		
        $three_object_plugin = plugins_url() . '/xr-publisher/build/';
        $three_object_plugin_root = plugins_url() . '/xr-publisher/';
		wp_localize_script( $handle, 'threeObjectPlugin', (array) $three_object_plugin );
		wp_localize_script( $handle, 'threeObjectPluginRoot', (array) $three_object_plugin_root );        if ( function_exists( 'wp_set_script_translations' ) ) {
			$path = plugin_dir_path( __FILE__ ) . 'languages';
			$language_directory = plugin_dir_path( dirname(__DIR__) ) . 'languages/';
			wp_set_script_translations( 'xr-publisher-settings', 'xr-publisher', $language_directory );
		}    
    }
});

//Register API Route to read and update settings.
add_action('rest_api_init', function (){
    //Register route
    register_rest_route( 'xr-publisher/v1' , '/xr-publisher-settings/', [
        //Endpoint to get settings from
        [
            'methods' => ['GET'],
			'callback' => function($request){
				return rest_ensure_response( [
					'enabled' => get_option( 'xr_publisher_ai_enabled', false ),
					'networkWorker' => get_option( 'xr_publisher_mp_networkWorker', '' ),
					'multiplayerWorker' => get_option( 'xr_publisher_mp_multiplayerWorker', '' ),
					'turnCredentialRelay' => get_option( 'xr_publisher_mp_turnCredentialRelay', '' ),
					'turnServerKey' => get_option( 'xr_publisher_mp_turnServerKey', '' ),
					'multiplayerAccess' => get_option( 'xr_publisher_mp_multiplayerAccess', '' ),
					'openApiKey' => xr_publisher_decrypt ( get_option( 'xr_publisher_ai_openApiKey', '' ) ),
					'allowPublicAI' => get_option( 'xr_publisher_ai_allow', '' ),
					'defaultVRM' => get_option( 'xr_publisher_defaultVRM', '' ),
					'defaultAvatar' => get_option( 'xr_publisher_defaultAvatar', '' ),
					'xrPublisherApiKey' => get_option( 'xr_publisher_proApiKey', '' ),
					'toyboxApiKey' => get_option( 'xr_publisher_toyboxApiKey', '' ),
				], 200);
			},
					'permission_callback' => function(){
                return current_user_can('manage_options');
            }
        ],
        //Endpoint to update settings at
        [
            'methods' => ['POST'],
			'callback' => function($request){
				$data = $request->get_json_params();
				update_option( 'xr_publisher_ai_enabled', $data['enabled'] );
				update_option( 'xr_publisher_mp_networkWorker', $data['networkWorker'] );
				update_option( 'xr_publisher_mp_multiplayerWorker', $data['multiplayerWorker'] );
				update_option( 'xr_publisher_mp_turnCredentialRelay', $data['turnCredentialRelay'] );
				update_option( 'xr_publisher_mp_turnServerUser', $data['turnServerUser'] );
				update_option( 'xr_publisher_mp_turnServerKey', $data['turnServerKey'] );
				update_option( 'xr_publisher_mp_multiplayerAccess', $data['multiplayerAccess'] );
				update_option( 'xr_publisher_defaultVRM', $data['defaultVRM'] );
				update_option( 'xr_publisher_defaultAvatar', $data['defaultAvatar'] );
				update_option( 'xr_publisher_ai_allow', $data['allowPublicAI'] );
				update_option( 'xr_publisher_ai_openApiKey', xr_publisher_encrypt( $data['openApiKey'] ) );
				update_option( 'xr_publisher_proApiKey', $data['xrPublisherApiKey'] );
				update_option( 'xr_publisher_toyboxApiKey', $data['toyboxApiKey'] );
				return rest_ensure_response( $data, 200);
			},
			'permission_callback' => function(){
                return current_user_can('manage_options');
            }
        ]
    ]);
});

//Enqueue assets for XR Publisher Settings on admin page only
add_action('admin_enqueue_scripts', function ($hook) {
    if ('toplevel_page_xr-publisher-settings' != $hook) {
        return;
    }
    wp_enqueue_script('xr-publisher-settings');
});

//Register XR Publisher Settings menu page
add_action('admin_menu', function () {
    add_menu_page(
        __('XR Publisher Settings', 'xr-publisher'),
        __('XR Publisher Settings', 'xr-publisher'),
        'manage_options',
        'xr-publisher-settings',
        function () {
            //React root
            echo '<div id="xr-publisher-settings"></div>';
        }
    );
}, 9);

function xr_publisher_encrypt($value = ""){
    if( empty( $value ) ) {
        return $value;
    }
    
    $output = null;
    $secret_key = defined('AUTH_KEY') ? AUTH_KEY : "";
    $secret_iv = defined('SECURE_AUTH_KEY') ? SECURE_AUTH_KEY : "";
    $key = hash('sha256',$secret_key);
    $iv = substr(hash('sha256',$secret_iv),0,16);
    return base64_encode(openssl_encrypt($value,"AES-256-CBC",$key,0,$iv));
}

function xr_publisher_decrypt($value = ""){
    if( empty( $value ) ) {
        return $value;
    }

    $output = null;
    $secret_key = defined('AUTH_KEY') ? AUTH_KEY : "";
    $secret_iv = defined('SECURE_AUTH_KEY') ? SECURE_AUTH_KEY : "";
    $key = hash('sha256',$secret_key);
    $iv = substr(hash('sha256',$secret_iv),0,16);

    return openssl_decrypt(base64_decode($value),"AES-256-CBC",$key,0,$iv);
}